/*------------------------------------------------------------------------------*
 * File Name:				 													*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * Sim 07-10-2006 v8.0440 GENERAL_WAVFILE_IMPORT								*
 * Sim 07-17-2006 ADD_FILE_NAME_TO_COL_AS_LONG_NAME								*
 *------------------------------------------------------------------------------*/
 
#include <origin.h>

#include "file_utils.h"

/// before call this function, you need set right siz first 
int file_read_data(file& ff, DataObject& dd, int nInternalType, UINT nBufferSize)
{
	dd.SetInternalDataType(nInternalType, 0);
	int nElementSize;				
	UINT nNumElements;				
	LPVOID lpData = dd.GetInternalDataBuffer(&nElementSize, &nNumElements);
	if ( nNumElements * nElementSize < nBufferSize )
		return -2;
	if( ff.Read(lpData, nBufferSize) != nBufferSize )
	{
		ff.Close();
		return -1;
	}
	dd.ReleaseBuffer();
	return 0; 
}

///---Sim 07-10-2006 v8.0440 GENERAL_WAVFILE_IMPORT
BinFile::BinFile(BOOL bImport) 
{
	m_bImport = bImport;
	m_strFileName = ""; ///---Sim 07-17-2006 ADD_FILE_NAME_TO_COL_AS_LONG_NAME
}

BinFile::BinFile(LPCSTR lpcszFileName, BOOL bImport) 
{
	m_bImport = bImport;
	Open(lpcszFileName); 
}

BinFile::~BinFile() 
{ 
	if (IsOpen())
		Close();
}
bool BinFile::Open(LPCSTR lpcszFileName)
{
	m_strFileName = lpcszFileName; ///---Sim 07-17-2006 ADD_FILE_NAME_TO_COL_AS_LONG_NAME
	if (m_bImport)
	{
		return Open(lpcszFileName, file::shareDenyNone | file::typeBinary);
	}
	return false;
}

///---end GENERAL_WAVFILE_IMPORT
